/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.HashMap;
import java.util.Hashtable;
import javax.imageio.ImageIO;
import javax.media.opengl.GL;

public class TextureLoader {
    private HashMap table = new HashMap();
    private GL gl;
    private ColorModel glAlphaColorModel;
    private ColorModel glColorModel;

    public TextureLoader(GL gl) {
        this.gl = gl;
        this.glAlphaColorModel = new ComponentColorModel(ColorSpace.getInstance(1000), new int[]{8, 8, 8, 8}, true, false, 3, 0);
        int[] nArray = new int[4];
        nArray[0] = 8;
        nArray[1] = 8;
        nArray[2] = 8;
        this.glColorModel = new ComponentColorModel(ColorSpace.getInstance(1000), nArray, false, false, 1, 0);
    }

    private int createTextureID() {
        int[] tmp = new int[1];
        this.gl.glGenTextures(1, IntBuffer.wrap(tmp));
        return tmp[0];
    }

    public Texture getTexture(String resourceName) throws IOException {
        Texture tex = (Texture)this.table.get(resourceName);
        if (tex != null) {
            return tex;
        }
        tex = this.getTexture(resourceName, 3553, 6408, 9729, 9729);
        this.table.put(resourceName, tex);
        return tex;
    }

    public Texture getTexture(String resourceName, int target, int dstPixelFormat, int minFilter, int magFilter) throws IOException {
        int srcPixelFormat = 0;
        int textureID = this.createTextureID();
        Texture texture = new Texture(target, textureID);
        this.gl.glBindTexture(target, textureID);
        BufferedImage bufferedImage = this.loadImage(resourceName);
        texture.setWidth(bufferedImage.getWidth());
        texture.setHeight(bufferedImage.getHeight());
        srcPixelFormat = bufferedImage.getColorModel().hasAlpha() ? 6408 : 6407;
        ByteBuffer textureBuffer = this.convertImageData(bufferedImage, texture);
        if (target == 3553) {
            this.gl.glTexParameteri(target, 10241, minFilter);
            this.gl.glTexParameteri(target, 10240, magFilter);
        }
        textureBuffer.flip();
        this.gl.glTexImage2D(target, 0, dstPixelFormat, this.get2Fold(bufferedImage.getWidth()), this.get2Fold(bufferedImage.getHeight()), 0, srcPixelFormat, 5121, textureBuffer);
        return texture;
    }

    private int get2Fold(int fold) {
        int ret = 2;
        while (ret < fold) {
            ret *= 2;
        }
        return ret;
    }

    private ByteBuffer convertImageData(BufferedImage bufferedImage, Texture texture) {
        BufferedImage texImage;
        ByteBuffer imageBuffer = null;
        int texWidth = 2;
        int texHeight = 2;
        while (texWidth < bufferedImage.getWidth()) {
            texWidth *= 2;
        }
        while (texHeight < bufferedImage.getHeight()) {
            texHeight *= 2;
        }
        texture.setTextureHeight(texHeight);
        texture.setTextureWidth(texWidth);
        if (bufferedImage.getColorModel().hasAlpha()) {
            WritableRaster raster = Raster.createInterleavedRaster(0, texWidth, texHeight, 4, null);
            texImage = new BufferedImage(this.glAlphaColorModel, raster, false, new Hashtable());
        } else {
            WritableRaster raster = Raster.createInterleavedRaster(0, texWidth, texHeight, 3, null);
            texImage = new BufferedImage(this.glColorModel, raster, false, new Hashtable());
        }
        Graphics g = texImage.getGraphics();
        g.setColor(new Color(0.0f, 0.0f, 0.0f, 0.0f));
        g.fillRect(0, 0, texWidth, texHeight);
        g.drawImage(bufferedImage, 0, 0, null);
        byte[] data = ((DataBufferByte)texImage.getRaster().getDataBuffer()).getData();
        imageBuffer = ByteBuffer.allocateDirect(data.length);
        imageBuffer.order(ByteOrder.nativeOrder());
        imageBuffer.put(data, 0, data.length);
        return imageBuffer;
    }

    private BufferedImage loadImage(String ref) throws IOException {
        URL url = TextureLoader.class.getClassLoader().getResource(ref);
        if (url == null) {
            throw new IOException("Cannot find: " + ref);
        }
        BufferedImage bufferedImage = ImageIO.read(new BufferedInputStream(this.getClass().getClassLoader().getResourceAsStream(ref)));
        return bufferedImage;
    }
}

