/*
 * Decompiled with CFR 0.152.
 */
import com.sun.opengl.util.Animator;
import java.awt.BorderLayout;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCanvas;
import javax.media.opengl.GLEventListener;

public class JoglGameWindow
implements GLEventListener {
    private Frame frame = new Frame();
    private Game callback;
    private int width;
    private int height;
    private GLCanvas canvas;
    private GL gl;
    private TextureLoader textureLoader;

    TextureLoader getTextureLoader() {
        return this.textureLoader;
    }

    GL getGL() {
        return this.gl;
    }

    public void setTitle(String title) {
        this.frame.setTitle(title);
    }

    public void setResolution(int x, int y) {
        this.width = x;
        this.height = y;
    }

    public void startRendering() {
        this.canvas = new GLCanvas();
        this.canvas.addGLEventListener(this);
        Keyboard.init(this.canvas);
        Animator animator = new Animator(this.canvas);
        this.frame.setLayout(new BorderLayout());
        this.frame.add(this.canvas);
        this.frame.setSize(this.width, this.height);
        this.frame.setResizable(false);
        this.frame.setVisible(true);
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (JoglGameWindow.this.callback != null) {
                    JoglGameWindow.this.callback.windowClosed();
                } else {
                    System.exit(0);
                }
            }
        });
        animator.start();
        this.canvas.requestFocus();
    }

    public void setGameWindowCallback(Game callback) {
        this.callback = callback;
    }

    public boolean isKeyPressed(int keyCode) {
        return Keyboard.isPressed(keyCode);
    }

    @Override
    public void init(GLAutoDrawable drawable) {
        System.out.println("Here");
        this.gl = ((GLCanvas)drawable).getGL();
        this.gl.glEnable(3553);
        this.gl.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        this.gl.glViewport(0, 0, this.width, this.height);
        this.gl.glDisable(2929);
        this.textureLoader = new TextureLoader(((GLCanvas)drawable).getGL());
        System.out.println("Here");
        if (this.callback != null) {
            this.callback.initialise();
        } else {
            System.out.println("BAD");
        }
    }

    @Override
    public void display(GLAutoDrawable drawable) {
        this.gl = this.canvas.getGL();
        this.gl.glClear(16640);
        this.gl.glMatrixMode(5888);
        this.gl.glLoadIdentity();
        if (this.callback != null) {
            this.callback.frameRendering();
        }
        this.gl.glFlush();
    }

    @Override
    public void reshape(GLAutoDrawable drawable, int x, int y, int width, int height) {
        this.gl = this.canvas.getGL();
        this.gl.glMatrixMode(5889);
        this.gl.glLoadIdentity();
        this.gl.glOrtho(0.0, width, height, 0.0, -1.0, 1.0);
    }

    @Override
    public void displayChanged(GLAutoDrawable drawable, boolean modeChanged, boolean deviceChanged) {
    }
}

