/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Rectangle;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Random;
import sun.audio.AudioPlayer;
import sun.audio.AudioStream;

public class Game
extends Canvas {
    private static final long serialVersionUID = -2914858856812762749L;
    public static final double FRICTION = 0.9;
    public static final double GRAVITY = 9.8;
    Random r = new Random();
    public ArrayList<Entity> entities = new ArrayList();
    private ArrayList<Entity> removeList = new ArrayList();
    private int moveSpeed = 200;
    private int jumpSpeed = 300;
    public Entity player;
    public Entity shellPlayer;
    boolean loading = false;
    private Sprite message;
    private boolean waitingForKeyPress = true;
    private boolean logicRequiredThisLoop = false;
    private long lastLoopTime = System.currentTimeMillis();
    private JoglGameWindow window = ResourceFactory.get().getGameWindow();
    private Sprite pressAnyKey;
    private Sprite youWin;
    private Sprite youLose;
    private long lastFpsTime = 0L;
    private int fps;
    public int currentScreen = 1;
    private String windowTitle = "Lunar Mind - Ludum Dare 18";
    private int countMindTime = 0;
    private int countExplodeTime = 0;
    private int timeToMindControl = 3000;
    private int timeToExplode = 3000;
    private int countMindParticleTime = 0;
    private int timeToMindParticle = 100;
    ParticleManager pm;

    public Game() {
        this.window.setResolution(800, 600);
        this.window.setGameWindowCallback(this);
        this.window.setTitle(this.windowTitle);
    }

    public void startRendering() {
        this.window.startRendering();
    }

    public void initialise() {
        this.youLose = ResourceFactory.get().getSprite("sprites/TextDisplay/youlose.png");
        this.pressAnyKey = ResourceFactory.get().getSprite("sprites/TextDisplay/pressspace.png");
        this.youWin = ResourceFactory.get().getSprite("sprites/youwin.gif");
        this.player = new Player(this, 0, 0);
        this.shellPlayer = new PlayerMindControlling("sprites/player/m1.png", this, -500, -500, -1, -1, -1, -1);
        this.message = this.pressAnyKey;
        this.pm = new ParticleManager(this);
        try {
            FileInputStream in = new FileInputStream("test.mid");
            AudioStream as = new AudioStream((InputStream)in);
            AudioPlayer.player.start((InputStream)as);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.startGame();
    }

    private void startGame() {
        ((Player)this.player).hp = 30;
        this.loadScreen(1, 200, 350);
    }

    public Enemy findNearestEnemy(double x, double y) {
        Entity nearestEnemy = null;
        double dist = 99999.0;
        int i = 0;
        while (i < this.entities.size()) {
            double dist2;
            Entity e = this.entities.get(i);
            if (e instanceof Enemy && (dist2 = Util.distBetween(x, y, e.x, e.y)) < dist) {
                dist = dist2;
                nearestEnemy = e;
            }
            ++i;
        }
        return (Enemy)nearestEnemy;
    }

    public void loadScreen(int screen, int playerX, int playerY) {
        this.loading = true;
        this.entities.clear();
        switch (screen) {
            case 1: {
                Background background = new Background("sprites/backgrounds/background1.png", this, 0, 0);
                this.entities.add(background);
                int i = 0;
                while (i < 4) {
                    int j = 0;
                    while (j < 1) {
                        Block block = new Block("sprites/platforms/short.png", 100 + i * 200, 500 + j * 90, 7, 20, 200, 80);
                        this.entities.add(block);
                        ++j;
                    }
                    ++i;
                }
                this.player.setPos(playerX, playerY);
                this.entities.add(this.player);
                ScreenChanger screenChanger = new ScreenChanger(this, 850, 380, 2, -100, 350);
                this.entities.add(screenChanger);
                break;
            }
            case 2: {
                Background background = new Background("sprites/backgrounds/backgroundBlah.png", this, 0, 0);
                this.entities.add(background);
                int i = 0;
                while (i < 5) {
                    int j = 0;
                    while (j < 1) {
                        Block block = new Block("sprites/platforms/short.png", -30 + i * 200, 500 + j * 90, 7, 20, 200, 80);
                        this.entities.add(block);
                        ++j;
                    }
                    ++i;
                }
                this.player.setPos(playerX, playerY);
                this.entities.add(this.player);
                Piston piston = new Piston(this, 500, 320);
                this.entities.add(piston);
                Lever lever = new Lever(this, 200, 440, piston);
                this.entities.add(lever);
                ScreenChanger screenChangerBack = new ScreenChanger(this, -100, 380, 1, 850, 350);
                this.entities.add(screenChangerBack);
                ScreenChanger screenChanger = new ScreenChanger(this, 850, 380, 3, -100, 350);
                this.entities.add(screenChanger);
                break;
            }
            case 3: {
                Background background = new Background("sprites/backgrounds/background2.png", this, 0, 0);
                this.entities.add(background);
                int i = 0;
                while (i < 4) {
                    int j = 0;
                    while (j < 1) {
                        Block block = new Block("sprites/platforms/med.png", -70 + i * 360, 500 + j * 90, 7, 20, 360, 80);
                        this.entities.add(block);
                        ++j;
                    }
                    ++i;
                }
                this.player.setPos(playerX, playerY);
                this.entities.add(this.player);
                Spider spider = new Spider(this, 500, 430);
                this.entities.add(spider);
                EnemyBouncer b1 = new EnemyBouncer(390, 470, false);
                EnemyBouncer b2 = new EnemyBouncer(750, 470, true);
                this.entities.add(b1);
                this.entities.add(b2);
                Piston piston = new Piston(this, 300, 320);
                this.entities.add(piston);
                Lever lever = new Lever(this, 400, 440, piston);
                this.entities.add(lever);
                ScreenChanger screenChangerBack = new ScreenChanger(this, -100, 380, 2, 850, 350);
                this.entities.add(screenChangerBack);
                ScreenChanger screenChanger = new ScreenChanger(this, 850, 380, 4, -100, 30);
                this.entities.add(screenChanger);
                break;
            }
            case 4: {
                Background background = new Background("sprites/backgrounds/background1.png", this, 0, 0);
                this.entities.add(background);
                Block block = new Block("sprites/platforms/short.png", -30, 200, 7, 20, 200, 80);
                this.entities.add(block);
                int i = 0;
                while (i < 2) {
                    int j = 0;
                    while (j < 1) {
                        Block block1 = new Block("sprites/platforms/long.png", -100 + i * 480, 500 + j * 90, 10, 20, 480, 80);
                        this.entities.add(block1);
                        ++j;
                    }
                    ++i;
                }
                this.player.setPos(playerX, playerY);
                this.entities.add(this.player);
                Spider spider = new Spider(this, 300, 430);
                this.entities.add(spider);
                Spider spider2 = new Spider(this, 500, 430);
                this.entities.add(spider2);
                Spider spider3 = new Spider(this, 680, 430);
                this.entities.add(spider3);
                EnemyBouncer b1 = new EnemyBouncer(20, 470, false);
                EnemyBouncer b2 = new EnemyBouncer(780, 470, true);
                this.entities.add(b1);
                this.entities.add(b2);
                ScreenChanger screenChangerBack = new ScreenChanger(this, -100, 70, 3, 850, 350);
                this.entities.add(screenChangerBack);
                ScreenChanger screenChanger = new ScreenChanger(this, 850, 380, 5, -100, 150);
                this.entities.add(screenChanger);
                ScreenChanger screenChanger2 = new ScreenChanger(this, -50, 380, -50, 850, 350);
                this.entities.add(screenChanger2);
                break;
            }
            case -50: {
                Background background = new Background("sprites/backgrounds/background1.png", this, 0, 0);
                this.entities.add(background);
                int i = 0;
                while (i < 2) {
                    int j = 0;
                    while (j < 1) {
                        Block block = new Block("sprites/platforms/short.png", 500 + i * 200, 500 + j * 90, 7, 20, 200, 80);
                        this.entities.add(block);
                        ++j;
                    }
                    ++i;
                }
                this.player.setPos(playerX, playerY);
                this.entities.add(this.player);
                ScreenChanger screenChanger = new ScreenChanger(this, 850, 380, 4, -100, 350);
                this.entities.add(screenChanger);
                break;
            }
            case 5: {
                Background background = new Background("sprites/backgrounds/background1.png", this, 0, 0);
                this.entities.add(background);
                int i = 0;
                while (i < 2) {
                    int j = 0;
                    while (j < 1) {
                        Block block = new Block("sprites/platforms/long.png", -100 + i * 480, 250 + j * 90, 10, 20, 480, 80);
                        this.entities.add(block);
                        ++j;
                    }
                    ++i;
                }
                this.player.setPos(playerX, playerY);
                this.entities.add(this.player);
                Spider spider = new Spider(this, 750, 150);
                this.entities.add(spider);
                EnemyBouncer b1 = new EnemyBouncer(20, 250, false);
                EnemyBouncer b2 = new EnemyBouncer(780, 250, true);
                this.entities.add(b1);
                this.entities.add(b2);
                ScreenChanger screenChanger = new ScreenChanger(this, -100, 180, 4, 850, 350);
                this.entities.add(screenChanger);
                ScreenChanger screenChanger2 = new ScreenChanger(this, 850, 180, 6, -50, 150);
                this.entities.add(screenChanger2);
                break;
            }
            case 6: {
                Background background = new Background("sprites/backgrounds/thanks.png", this, 0, 0);
                this.entities.add(background);
                int i = 0;
                while (i < 3) {
                    int j = 0;
                    while (j < 1) {
                        Block block = new Block("sprites/platforms/short.png", -100 + i * 200, 250 + j * 90, 10, 20, 200, 80);
                        this.entities.add(block);
                        ++j;
                    }
                    ++i;
                }
                this.player.setPos(playerX, playerY);
                this.entities.add(this.player);
                ScreenChanger screenChanger = new ScreenChanger(this, -100, 180, 5, 850, 150);
                this.entities.add(screenChanger);
            }
        }
        this.currentScreen = screen;
    }

    public void updateLogic() {
        this.logicRequiredThisLoop = true;
    }

    public void removeEntity(Entity entity) {
        this.removeList.add(entity);
    }

    public void notifyDeath() {
        this.message = this.youLose;
        this.waitingForKeyPress = true;
    }

    public void notifyWin() {
        this.message = this.youWin;
        this.waitingForKeyPress = true;
    }

    public void frameRendering() {
        long delta = System.currentTimeMillis() - this.lastLoopTime;
        if (this.loading) {
            delta = 0L;
            this.loading = false;
        }
        this.lastLoopTime = System.currentTimeMillis();
        this.lastFpsTime += delta;
        ++this.fps;
        if (this.lastFpsTime >= 1000L) {
            this.window.setTitle(String.valueOf(this.windowTitle) + " (FPS: " + this.fps + ")");
            this.lastFpsTime = 0L;
            this.fps = 0;
        }
        boolean leftPressed = this.window.isKeyPressed(37);
        boolean rightPressed = this.window.isKeyPressed(39);
        boolean spacePressed = this.window.isKeyPressed(32);
        boolean upPressed = this.window.isKeyPressed(38);
        boolean downPressed = this.window.isKeyPressed(40);
        boolean ePressed = this.window.isKeyPressed(69);
        boolean rPressed = this.window.isKeyPressed(82);
        Player p = (Player)this.player;
        if (!this.waitingForKeyPress) {
            if (leftPressed && !rightPressed) {
                this.player.setHorizontalMovement(-this.moveSpeed);
            } else if (rightPressed && !leftPressed) {
                this.player.setHorizontalMovement(this.moveSpeed);
            }
            if (upPressed && !downPressed) {
                boolean onGround = false;
                int i = 0;
                while (i < this.entities.size()) {
                    if (this.entities.get(i) instanceof Block) {
                        Rectangle other = new Rectangle();
                        Entity e = this.entities.get(i);
                        if (!this.entities.get(i).isCustomSize()) {
                            other.setBounds((int)e.x, (int)e.y, e.sprite.getWidth(), e.sprite.getHeight());
                        } else {
                            other.setBounds(e.rect.x, e.rect.y, e.rect.width, e.rect.height);
                        }
                        if (((Player)this.player).jumpSquare.intersects(other)) {
                            onGround = true;
                        }
                    }
                    ++i;
                }
                if (onGround) {
                    this.player.setVerticalMovement(-this.jumpSpeed);
                }
            } else if (!upPressed) {
                // empty if block
            }
            if (!p.mindControlling) {
                if (spacePressed && this.player.isStill()) {
                    Enemy nearestEnemy = this.findNearestEnemy(p.x, p.y);
                    p.initiatingMindControl = true;
                    if (nearestEnemy != null) {
                        this.countMindTime = (int)((long)this.countMindTime + delta);
                        this.countMindParticleTime = (int)((long)this.countMindParticleTime + delta);
                        if (this.countMindParticleTime > this.timeToMindParticle) {
                            this.pm.createMindWarpParticle((int)p.x, (int)p.y, (int)nearestEnemy.x, (int)nearestEnemy.y);
                            this.countMindParticleTime = 0;
                        }
                        if (this.countMindTime > this.timeToMindControl) {
                            p.justMindControlled = true;
                            p.mindControlling = true;
                            this.countMindTime = 0;
                            this.countMindParticleTime = 0;
                        }
                    }
                }
                if (!spacePressed || !this.player.isStill()) {
                    this.countMindTime = 0;
                    ((Player)this.player).initiatingMindControl = false;
                }
            } else {
                if (spacePressed) {
                    this.countExplodeTime = (int)((long)this.countExplodeTime + delta);
                    this.countMindParticleTime = (int)((long)this.countMindParticleTime + delta * 2L);
                    p.initiatingExplode = true;
                    if (this.countMindParticleTime > this.timeToMindParticle) {
                        this.pm.createMindWarpParticle((int)p.x, (int)p.y, (int)p.x + this.r.nextInt(100) - 50, (int)p.y + this.r.nextInt(100) - 50);
                        this.countMindParticleTime = 0;
                    }
                    if (this.countExplodeTime > this.timeToExplode) {
                        int i = 0;
                        while (i < 5) {
                            Chunk chunk = new Chunk("sprites/chunks/c1.png", this, (int)p.x, (int)p.y);
                            this.entities.add(chunk);
                            ++i;
                        }
                        ((Player)this.player).x = this.shellPlayer.x;
                        ((Player)this.player).y = this.shellPlayer.y;
                        this.removeEntity(this.shellPlayer);
                        p.mindControlling = false;
                        p.lastFrameChange = 99999L;
                        this.countExplodeTime = 0;
                    }
                }
                if (!spacePressed) {
                    this.countExplodeTime = 0;
                    ((Player)this.player).initiatingExplode = false;
                }
            }
            ((Player)this.player).attacking = ePressed && this.player.isStill();
            if (rPressed) {
                switch (this.currentScreen) {
                    case 1: {
                        this.loadScreen(1, 200, 350);
                        break;
                    }
                    case 2: {
                        this.loadScreen(2, 50, 350);
                        break;
                    }
                    case 3: {
                        this.loadScreen(3, 50, 350);
                        break;
                    }
                    case 4: {
                        this.loadScreen(4, 50, 30);
                        break;
                    }
                    case 5: {
                        this.loadScreen(5, 50, 130);
                    }
                    default: {
                        break;
                    }
                }
            }
        } else if (spacePressed) {
            this.waitingForKeyPress = false;
            System.out.println("New game");
            this.startGame();
        }
        if (this.window.isKeyPressed(27)) {
            System.exit(0);
        }
        if (!this.waitingForKeyPress) {
            int i = 0;
            while (i < this.entities.size()) {
                Entity entity = this.entities.get(i);
                entity.move(delta);
                ++i;
            }
        }
        int p1 = 0;
        while (p1 < this.entities.size()) {
            int s = p1 + 1;
            while (s < this.entities.size()) {
                Entity me = this.entities.get(p1);
                Entity him = this.entities.get(s);
                if (me.solid && him.solid && (!(me instanceof Block) || !(him instanceof Block)) && me.collidesWith(him)) {
                    me.collidedWith(him);
                    him.collidedWith(me);
                }
                ++s;
            }
            ++p1;
        }
        int i = 0;
        while (i < this.entities.size()) {
            Entity entity = this.entities.get(i);
            entity.draw();
            ++i;
        }
        if (this.waitingForKeyPress) {
            this.message.draw(425, 300);
        }
        this.entities.removeAll(this.removeList);
        this.removeList.clear();
    }

    public void windowClosed() {
        System.exit(0);
    }

    public static void main(String[] argv) {
        Game g = new Game();
        g.startRendering();
    }
}

