/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import javax.media.opengl.GL;

public class Sprite {
    private Texture texture;
    private JoglGameWindow window;
    private int width;
    private int height;
    public boolean flipHorizontal = false;

    public Sprite(JoglGameWindow window, String ref) {
        try {
            this.window = window;
            this.texture = window.getTextureLoader().getTexture(ref);
            this.width = this.texture.getImageWidth();
            this.height = this.texture.getImageHeight();
        }
        catch (IOException e) {
            System.err.println("Unable to load texture: " + ref);
            System.exit(0);
        }
    }

    public int getWidth() {
        return this.texture.getImageWidth();
    }

    public void flip() {
        this.flipHorizontal = !this.flipHorizontal;
    }

    public int getHeight() {
        return this.texture.getImageHeight();
    }

    public void draw(int x, int y) {
        GL gl = this.window.getGL();
        gl.glPushMatrix();
        this.texture.bind(gl);
        gl.glTranslatef(x, y, 0.0f);
        gl.glColor3f(1.0f, 1.0f, 1.0f);
        gl.glEnable(3042);
        gl.glBlendFunc(770, 771);
        gl.glBegin(7);
        if (!this.flipHorizontal) {
            gl.glTexCoord2f(0.0f, 0.0f);
            gl.glVertex2f(0.0f, 0.0f);
            gl.glTexCoord2f(0.0f, this.texture.getHeight());
            gl.glVertex2f(0.0f, this.height);
            gl.glTexCoord2f(this.texture.getWidth(), this.texture.getHeight());
            gl.glVertex2f(this.width, this.height);
            gl.glTexCoord2f(this.texture.getWidth(), 0.0f);
            gl.glVertex2f(this.width, 0.0f);
        } else {
            gl.glTexCoord2f(0.0f, 0.0f);
            gl.glVertex2f(this.width, 0.0f);
            gl.glTexCoord2f(0.0f, this.texture.getHeight());
            gl.glVertex2f(this.width, this.height);
            gl.glTexCoord2f(this.texture.getWidth(), this.texture.getHeight());
            gl.glVertex2f(0.0f, this.height);
            gl.glTexCoord2f(this.texture.getWidth(), 0.0f);
            gl.glVertex2f(0.0f, 0.0f);
        }
        gl.glEnd();
        gl.glPopMatrix();
    }
}

