/*
 * Decompiled with CFR 0.152.
 */
public class Lever
extends Entity {
    private Sprite[] animation = new Sprite[2];
    private int frameNumber;
    private long triggerTimeout = 1000L;
    private long triggerLast;
    public boolean triggered = false;
    Piston parent;

    public Lever(Game game, int x, int y, Piston parent) {
        super("sprites/mech/loff.png", x, y, -1, -1, -1, -1, true);
        this.parent = parent;
        this.animation[0] = ResourceFactory.get().getSprite("sprites/mech/loff.png");
        this.animation[1] = ResourceFactory.get().getSprite("sprites/mech/lon.png");
    }

    @Override
    public void collidedWith(Entity other) {
        if (other instanceof Player && ((Player)other).attacking && this.triggerLast > this.triggerTimeout) {
            this.triggered = !this.triggered;
            this.triggerLast = 0L;
            if (this.triggered) {
                this.sprite = this.animation[1];
                this.parent.up = false;
            } else {
                this.sprite = this.animation[0];
                this.parent.up = true;
            }
        }
    }

    @Override
    public void move(long delta) {
        this.triggerLast += delta;
    }
}

