/*
 * Decompiled with CFR 0.152.
 */
package org.crusty.g2103.towers;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import org.crusty.engine.Screen;
import org.crusty.g2103.Game;
import org.crusty.g2103.Maze;
import org.crusty.g2103.enemies.Enemy;
import org.crusty.g2103.gui.TowerButton;
import org.crusty.g2103.levels.LevelMaze;
import org.crusty.g2103.towers.Tower;
import org.crusty.math.Vec2;

public class LaserTower
extends Tower {
    private long timeBetweenShots = 500L;
    private long lengthOfLaser = 100L;
    private long lastTimeShot = 0L;
    private boolean laserOn = false;
    Enemy targettedEnemy = null;
    private Vec2 lastShootingPos;

    public LaserTower(Screen screen, Maze maze, int costOfThisTower, TowerButton tb) {
        super(screen, maze, costOfThisTower, tb);
        this.rangeRadius = 70;
        this.stage = 0;
        this.damage = 5;
        this.lastShootingPos = new Vec2(0.0, 0.0);
    }

    @Override
    public void draw(Graphics2D g) {
        super.draw(g);
        g.setColor(Color.WHITE);
        g.drawOval((int)this.pos.x - 4, (int)this.pos.y - 4, 8, 8);
        g.drawOval((int)this.pos.x - 5, (int)this.pos.y - 5, 10, 10);
        if (this.laserOn) {
            g.setColor(Color.WHITE);
            Vec2 dirVec = new Vec2(this.lastShootingPos.x - this.pos.x, this.lastShootingPos.y - this.pos.y);
            dirVec = dirVec.normalise();
            Vec2 vec = new Vec2(0.0, 0.0);
            int tailPartLen = 5;
            int fadeNum = 15;
            vec.x = dirVec.x * (double)tailPartLen;
            vec.y = dirVec.y * (double)tailPartLen;
            dirVec.x *= 150.0;
            dirVec.y *= 150.0;
            g.drawLine((int)this.pos.x, (int)this.pos.y, (int)(this.pos.x + dirVec.x), (int)(this.pos.y + dirVec.y));
            Vec2[] fade = new Vec2[fadeNum];
            int i = 0;
            while (i < fadeNum) {
                fade[i] = new Vec2(this.pos.x + dirVec.x + vec.x * (double)i, this.pos.y + dirVec.y + vec.y * (double)i);
                ++i;
            }
            i = 0;
            while (i < fadeNum - 1) {
                g.setComposite(AlphaComposite.getInstance(3, 1.0f - 1.0f / (float)fadeNum * (float)i));
                g.drawLine((int)fade[i].x, (int)fade[i].y, (int)fade[i + 1].x, (int)fade[i + 1].y);
                ++i;
            }
            g.setComposite(AlphaComposite.getInstance(3, 1.0f));
        }
    }

    @Override
    public void logic(long dt) {
        if (this.screen instanceof LevelMaze && !this.mouseHold) {
            if (this.laserOn && Game.currentTimeMillis() - this.lastTimeShot > this.lengthOfLaser) {
                this.laserOn = false;
            }
            if (this.laserOn && this.targettedEnemy != null) {
                this.lastShootingPos.x = this.targettedEnemy.pos.x;
                this.lastShootingPos.y = this.targettedEnemy.pos.y;
            }
            if (Game.currentTimeMillis() - this.lastTimeShot > this.timeBetweenShots) {
                this.targettedEnemy = ((LevelMaze)this.screen).getClosestEnemy(this.pos, this.rangeRadius);
                if (this.targettedEnemy != null) {
                    this.lastShootingPos.x = this.targettedEnemy.pos.x;
                    this.lastShootingPos.y = this.targettedEnemy.pos.y;
                    this.lastTimeShot = Game.currentTimeMillis();
                    this.laserOn = true;
                    Vec2 dirVec = new Vec2(this.targettedEnemy.pos.x - this.pos.x, this.targettedEnemy.pos.y - this.pos.y);
                    dirVec = dirVec.normalise();
                    dirVec.x *= 150.0;
                    dirVec.y *= 150.0;
                    int count = ((LevelMaze)this.screen).damageEnemies(this, this.pos.x, this.pos.y, this.pos.x + dirVec.x, this.pos.y + dirVec.y, this.damage);
                    this.enemiesKilled += count;
                    ++this.timesShot;
                }
            }
        }
    }
}

