/*
 * Decompiled with CFR 0.152.
 */
package org.crusty.g2103.towers;

import java.awt.Color;
import java.awt.Graphics2D;
import org.crusty.engine.Screen;
import org.crusty.g2103.Game;
import org.crusty.g2103.Maze;
import org.crusty.g2103.enemies.Enemy;
import org.crusty.g2103.gui.TowerButton;
import org.crusty.g2103.levels.LevelMaze;
import org.crusty.g2103.towers.Tower;
import org.crusty.math.Vec2;

public class FireTower
extends Tower {
    private long timeBetweenShots = 2000L;
    private long lengthOfFire = 500L;
    private long lastTimeShot = 0L;
    Enemy targettedEnemy = null;
    private boolean fireOn = false;

    public FireTower(Screen screen, Maze maze, int costOfThisTower, TowerButton tb) {
        super(screen, maze, costOfThisTower, tb);
        this.rangeRadius = 30;
        this.stage = 0;
        this.damage = 20;
    }

    @Override
    public void draw(Graphics2D g) {
        super.draw(g);
        g.setColor(Color.WHITE);
        g.drawLine((int)this.pos.x - 4, (int)this.pos.y - 4, (int)this.pos.x + 4, (int)this.pos.y + 4);
        g.drawLine((int)this.pos.x + 4, (int)this.pos.y - 4, (int)this.pos.x - 4, (int)this.pos.y + 4);
        if (this.fireOn) {
            g.setColor(Color.YELLOW);
            int i = 0;
            while (i < 5) {
                this.drawOvalAroundCenter(g, this.pos, 5 + i * 5);
                ++i;
            }
        }
    }

    public void drawOvalAroundCenter(Graphics2D g, Vec2 pos, int radius) {
        g.drawOval((int)pos.x - radius, (int)pos.y - radius, radius * 2, radius * 2);
    }

    @Override
    public void logic(long dt) {
        if (this.screen instanceof LevelMaze && !this.mouseHold) {
            if (this.fireOn && Game.currentTimeMillis() - this.lastTimeShot > this.lengthOfFire) {
                this.fireOn = false;
            }
            if (Game.currentTimeMillis() - this.lastTimeShot > this.timeBetweenShots) {
                this.targettedEnemy = ((LevelMaze)this.screen).getClosestEnemy(this.pos, this.rangeRadius);
                if (this.targettedEnemy != null) {
                    this.lastTimeShot = Game.currentTimeMillis();
                    this.fireOn = true;
                    int count = ((LevelMaze)this.screen).damageEnemies(this, this.pos, this.rangeRadius, this.damage);
                    this.enemiesKilled += count;
                    ++this.timesShot;
                }
            }
        }
    }
}

