/*
 * Decompiled with CFR 0.152.
 */
package org.crusty.g2103.levels;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import org.crusty.engine.CrustyEngine;
import org.crusty.engine.FontStore;
import org.crusty.engine.GUI.Button;
import org.crusty.engine.GUI.MouseOverPane;
import org.crusty.engine.RootEntity;
import org.crusty.engine.Screen;
import org.crusty.g2103.Cell;
import org.crusty.g2103.Game;
import org.crusty.g2103.HPFloater;
import org.crusty.g2103.Maze;
import org.crusty.g2103.Sound;
import org.crusty.g2103.enemies.Enemy;
import org.crusty.g2103.enemies.spawners.WaveSpawner;
import org.crusty.g2103.gui.FastForwardButton;
import org.crusty.g2103.gui.NextWaveButton;
import org.crusty.g2103.gui.TowerButton;
import org.crusty.g2103.towers.CannonTower;
import org.crusty.g2103.towers.FireTower;
import org.crusty.g2103.towers.LaserTower;
import org.crusty.g2103.towers.SlugTower;
import org.crusty.g2103.towers.Tower;
import org.crusty.mandelbrot.Mandelbrot;
import org.crusty.math.Vec2;

public class LevelMaze
extends Screen {
    Color mainColor = Color.YELLOW;
    Maze maze;
    int gold;
    int score;
    Font mainFont = FontStore.smallFont;
    int sx = 570;
    int sy = 50;
    Cell[][] cells;
    private Cell start;
    Button b;
    Button laserTowerButton;
    Button fireTowerButton;
    Button slugTowerButton;
    Button cannonTowerButton;
    private int enemyWaveNum;
    private int waveNum;
    Image background;

    public LevelMaze(CrustyEngine engine) {
        super(engine);
        this.initMaze();
        Game.setTimeMultiplier(1);
        String[] text = new String[]{"Click to spawn the next wave.", "Each successive wave will spawn", "more enemies than before."};
        this.b = new NextWaveButton(this, this.sx + 20, this.sy + 460, 80, 22, new MouseOverPane(this, text));
        this.b.setText("Next Wave");
        this.laserTowerButton = new TowerButton(this, this.sx + 20, this.sy + 110, 60, 60, "LaserTower", 50, new MouseOverPane(this, new String[]{"- Laser Tower -", "Fires a long laser stream", "that damages many enemies", "in a single shot."}));
        this.fireTowerButton = new TowerButton(this, this.sx + 100, this.sy + 110, 60, 60, "FireTower", 50, new MouseOverPane(this, new String[]{"- Fire Tower -", "Blasts enemies surrounding", "the tower with heavy fire", "damage."}));
        this.slugTowerButton = new TowerButton(this, this.sx + 20, this.sy + 190, 60, 60, "SlugTower", 50, new MouseOverPane(this, new String[]{"- Slug Tower -", "Fires extremely fast low-damage", "slugs at the enemy."}));
        this.cannonTowerButton = new TowerButton(this, this.sx + 100, this.sy + 190, 60, 60, "CannonTower", 50, new MouseOverPane(this, new String[]{"- Cannon Tower -", "Fires a single high-powered", "projectile inflicting high", "damage."}));
        FastForwardButton fastForwardButton = new FastForwardButton(this, this.sx + 120, this.sy + 460, 40, 22, new MouseOverPane(this, new String[]{"Speed up time!"}));
        this.addEntity(fastForwardButton);
        this.addEntity(this.cannonTowerButton);
        this.addEntity(this.fireTowerButton);
        this.addEntity(this.slugTowerButton);
        this.addEntity(this.laserTowerButton);
        this.addEntity(this.maze);
        this.addEntity(this.b);
        this.background = Mandelbrot.renderRandom(800, 600);
    }

    public void initMaze() {
        this.maze = new Maze(25, 25);
        this.gold = 300;
        this.score = 0;
        this.cells = this.maze.getCells();
        this.start = this.cells[0][0];
        this.enemyWaveNum = 1;
        this.waveNum = 1;
    }

    public Maze getMaze() {
        return this.maze;
    }

    public void setStart(Cell start) {
        this.start = start;
    }

    public Cell getStart() {
        return this.start;
    }

    public void setEnemyWaveNum(int currentWave) {
        this.enemyWaveNum = currentWave;
    }

    public int getEnemyWaveNum() {
        return this.enemyWaveNum;
    }

    public int getWaveNum() {
        return this.waveNum;
    }

    public Enemy getClosestEnemy(Vec2 pos, double range) {
        Enemy en = null;
        double dist = range;
        for (RootEntity e : this.entities) {
            double d;
            if (!(e instanceof Enemy) || !((d = new Vec2(pos.x - e.pos.x, pos.y - e.pos.y).length()) < dist)) continue;
            dist = d;
            en = (Enemy)e;
        }
        return en;
    }

    public int damageEnemies(Tower tower, double x1, double y1, double x2, double y2, int damage) {
        int count = 0;
        for (RootEntity e : this.entities) {
            if (!(e instanceof Enemy) || !e.getRect().intersectsLine(x1, y1, x2, y2)) continue;
            tower.incDamageDone(damage);
            if (!((Enemy)e).doDamage(damage)) continue;
            ++count;
        }
        return count;
    }

    public int damageEnemies(Tower tower, Vec2 pos, int rangeRadius, int damage) {
        int count = 0;
        for (RootEntity e : this.entities) {
            Vec2 vec;
            if (!(e instanceof Enemy) || !((vec = new Vec2(e.pos.x - pos.x, e.pos.y - pos.y)).length() <= (double)rangeRadius)) continue;
            tower.incDamageDone(damage);
            if (!((Enemy)e).doDamage(damage)) continue;
            ++count;
        }
        return count;
    }

    public void createHPFloater(String text, Vec2 pos, long lifeTime) {
        this.addEntity(new HPFloater(this, text, pos, lifeTime));
    }

    public void pickUpTower(TowerButton towerButton, MouseEvent e) {
        Tower t1 = null;
        String towerType = towerButton.getTowerType();
        int cost = towerButton.getCost();
        t1 = towerType.equals("LaserTower") ? new LaserTower(this, this.maze, cost, towerButton) : (towerType.equals("FireTower") ? new FireTower(this, this.maze, cost, towerButton) : (towerType.equals("SlugTower") ? new SlugTower(this, this.maze, cost, towerButton) : (towerType.equals("CannonTower") ? new CannonTower(this, this.maze, cost, towerButton) : new LaserTower(this, this.maze, cost, towerButton))));
        if (this.gold - cost >= 0) {
            this.gold -= cost;
            t1.setMouseHold(true);
            t1.setMousePos(e);
            this.addEntity(t1);
            System.out.println("New Tower: " + towerType);
            Sound.t5.play();
            towerButton.incCost();
        } else {
            System.out.println("Insufficient funds");
            Sound.t3.play();
        }
    }

    public void unselectEverything() {
        for (RootEntity t : this.entities) {
            if (!(t instanceof Tower)) continue;
            ((Tower)t).setSelected(false);
        }
    }

    public void killEnemy(Enemy e, int gold) {
        this.entities.remove(e);
        this.gold += gold;
        this.score += gold;
        System.out.println("Enemy died.");
        Sound.t2.play();
    }

    public void removeTower(Tower tower, int cost) {
        this.entities.remove(tower);
        this.gold += cost;
    }

    public void removeSpawner(WaveSpawner waveSpawner) {
        this.entities.remove(waveSpawner);
        this.setEnemyWaveNum((int)((double)this.getEnemyWaveNum() + Math.ceil((float)this.getEnemyWaveNum() * 0.4f)));
        ++this.waveNum;
    }

    @Override
    public void draw(Graphics2D g) {
        g.setComposite(AlphaComposite.getInstance(3, 0.3f));
        g.drawImage(this.background, 0, 0, null);
        g.setComposite(AlphaComposite.getInstance(3, 1.0f));
        g.setColor(this.mainColor);
        g.drawLine(this.sx, this.sy, this.sx + 5, this.sy);
        g.drawLine(Game.width - 55, this.sy, Game.width - 50, this.sy);
        g.drawLine(this.sx, Game.height - 50, this.sx + 5, Game.height - 50);
        g.drawLine(Game.width - 55, Game.height - 50, Game.width - 50, Game.height - 50);
        g.drawLine(this.sx, this.sy, this.sx, Game.height - 50);
        g.drawLine(Game.width - 50, this.sy, Game.width - 50, Game.height - 50);
        g.setColor(Color.WHITE);
        g.setFont(this.mainFont);
        g.drawString("Gold:  " + this.gold, this.sx + 20, this.sy + 20);
        g.drawString("Score: " + this.score, this.sx + 20, this.sy + 40);
        g.drawString("Wave:  " + this.getWaveNum(), this.sx + 20, this.sy + 60);
        super.draw(g);
    }

    @Override
    public void logic(long dt) {
        super.logic(dt);
    }

    public int getScore() {
        return this.score;
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }
}

