/*
 * Decompiled with CFR 0.152.
 */
package org.crusty.g2103.enemies;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.util.Random;
import org.crusty.engine.RootEntity;
import org.crusty.engine.Screen;
import org.crusty.g2103.Cell;
import org.crusty.g2103.Game;
import org.crusty.g2103.Maze;
import org.crusty.g2103.Sound;
import org.crusty.g2103.levels.LevelMaze;
import org.crusty.g2103.levels.LevelNameInput;
import org.crusty.math.Vec2;
import org.crusty.math.Vec2int;

public abstract class Enemy
extends RootEntity {
    int hp;
    int maxhp;
    boolean move;
    Vec2int tar;
    Cell curCell;
    Cell prevCell = null;
    double speed;
    Maze maze;
    Screen screen;
    boolean dead = false;
    int gold;

    public Enemy(Screen screen, Maze maze, Cell pathStart, double speed, int hp) {
        Random r = new Random();
        this.gold = 7 + r.nextInt(3);
        this.screen = screen;
        this.hp = hp;
        this.maxhp = hp;
        this.move = true;
        this.speed = speed;
        this.curCell = pathStart;
        this.maze = maze;
        this.tar = maze.gridCoordsToPos(this.curCell.pos);
    }

    public boolean isDead() {
        return this.dead;
    }

    public boolean doDamage(int damage) {
        if (!this.dead) {
            this.hp -= damage;
            if (this.screen instanceof LevelMaze) {
                ((LevelMaze)this.screen).createHPFloater("" + damage, this.pos, 300 + damage * 100);
            }
            if (this.hp < 0) {
                this.hp = 0;
                if (this.screen instanceof LevelMaze) {
                    ((LevelMaze)this.screen).killEnemy(this, this.gold);
                }
                this.dead = true;
                return true;
            }
        }
        return false;
    }

    @Override
    public void logic(long dt) {
        if (this.move) {
            Vec2 vec = new Vec2((double)this.tar.x - this.pos.x, (double)this.tar.y - this.pos.y);
            Vec2 acc = vec.normalise();
            this.acc.x = acc.x * this.speed;
            this.acc.y = acc.y * this.speed;
            if (vec.length() < this.speed * 0.5) {
                this.acc.x = 0.0;
                this.acc.y = 0.0;
                this.vel.x = 0.0;
                this.vel.y = 0.0;
                this.pos.x = this.tar.x;
                this.pos.y = this.tar.y;
                if (this.curCell.hasNextSinglePath(this.prevCell)) {
                    Cell prevTemp = this.curCell;
                    this.curCell = this.curCell.getNextSinglePath(this.prevCell);
                    this.prevCell = prevTemp;
                    this.tar = this.maze.gridCoordsToPos(this.curCell.pos);
                } else {
                    System.out.println("Game over.");
                    LevelNameInput nameInput = (LevelNameInput)((Game)this.screen.getEngine()).screenNameInput;
                    nameInput.reset();
                    this.screen.setCurrentScreen(nameInput);
                    this.move = false;
                    Sound.endGame.play();
                }
            }
        }
        super.logic(dt);
        this.setRect((int)this.pos.x - 5, (int)this.pos.y - 5, 10, 10);
    }

    @Override
    public void draw(Graphics2D g) {
        g.setColor(Color.RED);
        Vec2int hpBox = new Vec2int((int)this.pos.x - 5, (int)this.pos.y - 8);
        g.fillRect(hpBox.x, hpBox.y, 11, 2);
        g.setColor(Color.YELLOW);
        int hpPerc = (int)((float)this.hp / (float)this.maxhp * 11.0f);
        g.fillRect(hpBox.x, hpBox.y, hpPerc, 2);
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }
}

