/*
 * Decompiled with CFR 0.152.
 */
package org.crusty.engine;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.URL;
import java.util.HashMap;
import javax.imageio.ImageIO;
import org.crusty.engine.ImageManager;
import org.crusty.engine.Sprite;

public class SpriteManager {
    static HashMap<String, Sprite> sprites = new HashMap();
    String spritesFile = "sprites.crusty";

    public void loadSprites() {
        try {
            FileInputStream fis = new FileInputStream(new File(this.spritesFile));
            ObjectInputStream ois = new ObjectInputStream(fis);
            ois.close();
            fis.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void addSprite(String str) {
        Sprite s = new Sprite(SpriteManager.loadImage(str));
        sprites.put(str, s);
    }

    private static BufferedImage loadImage(String str) {
        BufferedImage image = null;
        URL url = ClassLoader.getSystemResource(str);
        BufferedImage bi = null;
        try {
            bi = ImageIO.read(url);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        image = ImageManager.makeColorTransparent(bi, Color.RED);
        return image;
    }

    public static Sprite getSprite(String str) {
        Sprite s = sprites.get(str);
        if (s != null) {
            return s;
        }
        System.out.println("Can't find: " + str);
        System.exit(-1);
        return null;
    }
}

