/*
 * Decompiled with CFR 0.152.
 */
package org.crusty.engine;

import java.awt.Graphics2D;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.concurrent.PriorityBlockingQueue;
import org.crusty.engine.CrustyEngine;
import org.crusty.engine.DepthComparator;
import org.crusty.engine.RootEntity;

public abstract class Screen {
    private DepthComparator depthComparator = new DepthComparator();
    protected PriorityBlockingQueue<RootEntity> entities = new PriorityBlockingQueue<RootEntity>(10, this.depthComparator);
    private CrustyEngine engine;

    public Screen(CrustyEngine engine) {
        this.engine = engine;
    }

    public PriorityBlockingQueue<RootEntity> getEntities() {
        return this.entities;
    }

    public CrustyEngine getEngine() {
        return this.engine;
    }

    public void addEntity(RootEntity e) {
        this.getEntities().add(e);
    }

    public void setCurrentScreen(Screen s) {
        this.engine.setCurrentScreen(s);
    }

    public void notifyRemoval(RootEntity e) {
        this.getEntities().remove(e);
    }

    public void draw(Graphics2D g) {
        Iterator<RootEntity> it = this.getEntities().iterator();
        while (it.hasNext()) {
            it.next().draw(g);
        }
    }

    public void logic(long dt) {
        Iterator<RootEntity> it = this.getEntities().iterator();
        while (it.hasNext()) {
            it.next().logic(dt);
        }
    }

    public void mousePressed(MouseEvent e) {
        for (RootEntity e1 : this.getEntities()) {
            e1.mousePressed(e);
        }
    }

    public void mouseMoved(MouseEvent e) {
        for (RootEntity e1 : this.getEntities()) {
            e1.mouseMoved(e);
        }
    }

    public abstract void keyTyped(KeyEvent var1);
}

