/*
 * Decompiled with CFR 0.152.
 */
package org.crusty.engine;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.RescaleOp;
import org.crusty.engine.RootEntity;
import org.crusty.engine.Sprite;
import org.crusty.math.Vec2;

public class Entity
extends RootEntity {
    protected Vec2 rotatePoint;
    protected Sprite sprite;
    protected double rotation = 0.0;
    protected double rotationalVel = 0.0;
    protected float scale = 1.0f;

    public Entity(Sprite sprite) {
        this.sprite = sprite;
        this.rotatePoint = new Vec2(sprite.image.getWidth() / 2, sprite.image.getHeight() / 2);
    }

    @Override
    public void logic(long dt) {
        super.logic(dt);
        this.rotation += this.rotationalVel * (double)dt / 1000000.0;
    }

    @Override
    public void draw(Graphics2D g) {
        AffineTransform save = g.getTransform();
        g.rotate(this.rotation, this.pos.x + this.rotatePoint.x, this.pos.y + this.rotatePoint.y);
        float[] scales = new float[]{1.0f, 1.0f, 1.0f, this.alpha};
        float[] offsets = new float[4];
        RescaleOp rop = new RescaleOp(scales, offsets, null);
        g.setComposite(AlphaComposite.getInstance(3, this.alpha));
        g.drawImage(this.sprite.image, rop, (int)this.pos.x, (int)this.pos.y);
        g.setComposite(AlphaComposite.getInstance(3, 1.0f));
        g.rotate(-this.rotation, this.pos.x + this.rotatePoint.x, this.pos.y + this.rotatePoint.y);
        g.setTransform(save);
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }
}

