/*
 * Decompiled with CFR 0.152.
 */
package org.crusty.engine;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.RenderingHints;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferStrategy;
import java.awt.image.BufferedImage;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.crusty.engine.FontStore;
import org.crusty.engine.Screen;

public abstract class CrustyEngine
extends Canvas
implements MouseListener,
MouseMotionListener,
KeyListener {
    private static final long serialVersionUID = -264862915258733931L;
    protected Screen currentScreen = null;
    public static boolean[] keys;
    private BufferStrategy strategy;
    private long lastTime;
    private long dt;
    private long accumulator;
    private long deltaTime = 10000000L;
    public static long timePassed;
    private GraphicsConfiguration gc;
    private static float fps;
    public static int width;
    public static int height;
    private static int timeMultiplier;
    protected static long currentTime;
    static boolean notifyUpdateScreen;
    JFrame container;

    static {
        timePassed = 0L;
        timeMultiplier = 1;
        currentTime = 0L;
        notifyUpdateScreen = false;
    }

    public CrustyEngine(int width, int height, String title) {
        CrustyEngine.width = width;
        CrustyEngine.height = height;
        this.loadImages();
        this.init(width, height, title);
    }

    public void init(int width, int height, String title) {
        keys = new boolean[255];
        this.container = new JFrame(title);
        JPanel panel = (JPanel)this.container.getContentPane();
        panel.setPreferredSize(new Dimension(width, height));
        panel.setLayout(null);
        this.setSize(new Dimension(width, height));
        panel.add(this);
        this.setIgnoreRepaint(true);
        this.container.pack();
        this.container.setResizable(false);
        this.container.setVisible(true);
        this.container.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.requestFocus();
        this.createBufferStrategy(2);
        this.strategy = this.getBufferStrategy();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gd = ge.getDefaultScreenDevice();
        this.gc = gd.getDefaultConfiguration();
    }

    public void setCurrentScreen(Screen s) {
        this.currentScreen = s;
    }

    public Screen getCurrentScreen() {
        return this.currentScreen;
    }

    public static long currentTimeMillis() {
        return currentTime;
    }

    public static void setTimeMultiplier(int mult) {
        timeMultiplier = mult;
    }

    public static int getTimeMultiplier() {
        return timeMultiplier;
    }

    public abstract void loadImages();

    public void draw(Graphics2D g) {
        this.currentScreen.draw(g);
    }

    public void gameLoop() {
        boolean running = true;
        boolean firstTime = true;
        BufferedImage bi = this.gc.createCompatibleImage(width, height);
        Graphics2D g = null;
        Graphics graphics = null;
        while (running) {
            long now = System.nanoTime();
            this.dt = now - this.lastTime;
            fps = 1000000000L / this.dt;
            this.lastTime = now;
            this.accumulator += this.dt;
            if (firstTime) {
                this.accumulator = 0L;
                firstTime = false;
            }
            while (this.accumulator >= this.deltaTime) {
                timePassed += this.deltaTime;
                int i = 0;
                while (i < timeMultiplier) {
                    this.logic(this.deltaTime);
                    currentTime += this.deltaTime / 1000000L;
                    ++i;
                }
                this.accumulator -= this.deltaTime;
            }
            while (true) {
                g = bi.createGraphics();
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                this.draw(g);
                g.setFont(FontStore.smallFont);
                g.setColor(Color.WHITE);
                g.drawString("FPS: " + CrustyEngine.getFps(), 15, 20);
                graphics = this.strategy.getDrawGraphics();
                graphics.drawImage(bi, 0, 0, null);
                if (this.strategy.contentsRestored()) continue;
                this.strategy.show();
                Thread.yield();
                if (graphics != null) {
                    graphics.dispose();
                }
                if (g != null) {
                    g.dispose();
                }
                if (!this.strategy.contentsLost()) break;
            }
        }
    }

    public void logic(long dt) {
        this.currentScreen.logic(dt);
    }

    public static float getFps() {
        return fps;
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() < 255) {
            CrustyEngine.keys[e.getKeyCode()] = true;
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() < 255) {
            CrustyEngine.keys[e.getKeyCode()] = false;
        }
    }
}

